/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Material material_brick,
         material_fur,
         material_glow,
         material_rfl;
Mesh     mesh;
/******************************************************************************/
void InitPre()
{
   App.name="Rendering Materials";
   App.flag=APP_MS_EXCLUSIVE;
   PakAdd("../data/engine.pak");

   D.full(true);
}
/******************************************************************************/
Bool Init()
{
   Cam.dist=4;

   material_brick.reset();                                    // setup defaults
   material_brick.diffuse=Gfxs("../data/mtrl/brick/0.gfx"  ); // set diffuse texture
   material_brick.normal =Gfxs("../data/mtrl/brick/0.n.gfx"); // set normal  texture
   material_brick.detail =Gfxs("../data/mtrl/brick/det.gfx"); // set detail  texture

   material_fur.reset();             // setup defaults
   material_fur.technique=MTECH_FUR; // set fur technique
   material_fur.color.w=1;           // in  fur technique alpha color is used for fur length
   material_fur.det_scale/=2;        // in  fur technique det_scale   is used for fur scale

   material_glow.reset();  // setup defaults
   material_glow.glow=0.5; // set glow amount

   material_rfl.reset();                                       // setup defaults
   material_rfl.diffuse   =Gfxs("../data/mtrl/glass/0.gfx"  ); // set diffuse texture to white
   material_rfl.normal    =Gfxs("../data/mtrl/glass/0.n.gfx"); // set normal  texture
   material_rfl.reflection=Gfxs("../data/mtrl/glass/rfl.gfx"); // set reflection texture
   material_rfl.color.set(1,0.66,0.33,0); // set color
   material_rfl.specular=0.5 ;            // set specular
   material_rfl.bump    =0.09;            // set bump value
   material_rfl.rough   =0.05;            // set roughness
   material_rfl.reflect =0.8 ;            // set reflection

   mesh.create(1).B(0).create(Ball(1),VTX_TX0|VTX_NRM|VTX_TNG); // create Mesh with 1 Mshb, and create this Mshb from Ball and automatic texture coordinates, normals and tangents
   mesh.setRender().setBox();                                   // set mesh rendering version and bounding box

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(1.5,10,CAMH_ZOOM|CAMH_ROT);
   
   if(Ms.b(0)) // on left mouse button change colors of materials
   {
      material_glow .color.x=0.5;
      material_brick.color.y=0.5;
      material_fur  .color.z=0.5;
   }else
   {
      // restore default rgb color values
      material_glow .color.v3=1;
      material_brick.color.v3=1;
      material_fur  .color.v3=1;
   }
   
   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_FUR  : // here since fur technique is being used we must process also 'RM_FUR' mode, in it we can simply render everything which is in 'RM_SOLID' mode
      case RM_SOLID:
         mesh.setMaterial(&material_glow ).draw(Matrix(Vec(-1, 1,0)));
         mesh.setMaterial(&material_brick).draw(Matrix(Vec( 1, 1,0)));
         mesh.setMaterial(&material_fur  ).draw(Matrix(Vec( 1,-1,0)));
         mesh.setMaterial(&material_rfl  ).draw(Matrix(Vec(-1,-1,0)));
      break;

      case RM_LIGHT: LightDir(1,Vec(0,0,1)).add(); break;
   }
}
void Draw()
{
   Renderer(Render);
}
/******************************************************************************/
